VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Public WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub



Public Function ConvertFile(ByVal ConfType As TConformanceType, ByVal InFile As String, ByVal OutFile As String) As Boolean
   Dim retval As Long, convFlags As Long

   ConvertFile = False

   Call pdf.CreateNewPDF(vbNullString)                         ' The output file will be created later
   Call pdf.SetDocInfo(TDocumentInfo.diProducer, vbNullString) ' No need to override the original producer

   Select Case ConfType
      Case TConformanceType.ctNormalize
         convFlags = TCheckOptions.coAllowDeviceSpaces ' For normalization it is not required to convert device spaces to ICC based color spaces.
      Case TConformanceType.ctPDFA_1b_2005
         convFlags = TCheckOptions.coDefault Or TCheckOptions.coFlattenLayers        ' Presentations are not prohibited in PDF/A 1.
      Case TConformanceType.ctPDFA_2b Or TConformanceType.ctPDFA_2u
         convFlags = TCheckOptions.coDefault Or TCheckOptions.coDeletePresentation
      Case Else
         ' ctPDFA_3b, ctPDFA_4, ctPDFA_4e, ctPDFA_4f, ctZUGFeRD_Basic, ctZUGFeRD_Comfort, ctZUGFeRD_Extended
         convFlags = TCheckOptions.coDefault Or TCheckOptions.coDeletePresentation
         convFlags = convFlags And Not TCheckOptions.coDeleteEmbeddedFiles          ' Embedded files are allowed in PDF/A 3.
   End Select

   ' These flags require some processing time but they are very useful.
   convFlags = convFlags Or TCheckOptions.coCheckImages
   convFlags = convFlags Or TCheckOptions.coRepairDamagedImages

   If ConfType <> TConformanceType.ctNormalize Then
      ' The flag ifPrepareForPDFA is required. The flag ifImportAsPage makes sure that pages will not be converted to templates.
      Call pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage Or TImportFlags.ifPrepareForPDFA)
      ' The flag if2UseProxy reduces the memory usage. The duplicate check is optional but recommended.
      Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy Or TImportFlags2.if2DuplicateCheck)
   Else
      Call pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage)
      Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy Or TImportFlags2.if2DuplicateCheck Or TImportFlags2.if2Normalize)
   End If
   retval = pdf.OpenImportFile(InFile, TPwdType.ptOpen, vbNullString)
   If retval < 0 Then
      If pdf.IsWrongPwd(retval) Then
         Call MsgBox("PDFError File is encrypted!")
      End If
      Call pdf.FreePDF
      Exit Function
   End If
   Call pdf.ImportPDFFile(1, 1#, 1#)
   Call pdf.CloseImportFile

   ' The CMYK profile is just an example profile that can be delivered with DynaPDF.
   ' Note that this code requires the PDF/A Extension for DynaPDF.
   retval = pdf.CheckConformance(ConfType, convFlags, ObjPtr(Me), AddressOf FontNotFoundProc, AddressOf ReplaceICCProfileProc)
   Select Case retval
      Case 1
         pdf.AddOutputIntent ("../../../test_files/sRGB.icc")
      Case 2
         pdf.AddOutputIntent ("../../../test_files/ISOcoated_v2_bas.ICC") ' This is just an example CMYK profile that can be delivered with DynaPDF
      Case 3
        pdf.AddOutputIntent ("../../../test_files/gray.icc")
   End Select
   ' No fatal error occurred?
   If pdf.HaveOpenDoc() Then
      If Not pdf.OpenOutputFile(OutFile) Then
         Call pdf.FreePDF
         Exit Function
      End If
      ConvertFile = pdf.CloseFile()
   End If
End Function

Private Sub Command1_Click()
   Dim OutFile As String
   OutFile = App.Path & "\out.pdf"

   ' -------------------------------------------------- ZUGFeRD invoice creation ---------------------------------------------------------
      ' To create a ZUGFeRD invoice attach the required XML invoice here and set the conversion type to the ZUGFeRD profile that you need.

      ' Example (ZUGFeRD 2.1):
      ' Call pdf.AttachFile("c:/invoices/test/factur-x.xml", "ZUGFeRD 2.1 Rechnung", True)
      ' If ConvertFile(ctFacturX_Basic, "c:/invoices/test/TestInvoice.pdf", OutFile) Then
      '    ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
      ' End If

      ' The file name of the XML invoice must be ZUGFeRD-invoice.xml. If the file has another name than rename it or use AttachFileEx() instead.
   ' -------------------------------------------------------------------------------------------------------------------------------------

   If ConvertFile(ctPDFA_3b, "../../../../dynapdf_help.pdf", OutFile) Then
      ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   ' Set the license key here if you have one
   ' Call pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' External cmaps should be loaded if possible.
   Call pdf.SetCMapDir(GetFullPath("../../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
